#include <bits/stdc++.h>
using namespace std;

const int N = 2e5;
const int B = 25;

vector<int> g[N];
int dis[N], vis[N];
int n, par[N][B], p[N];
int d[2][N];

void dfs(int x) {
    vis[x] = 1;
    for (int i : g[x]) {
        if (!vis[i]) {
            par[i][0] = x;
            dis[i] = dis[x] + 1;
            for (int j = 1; j < B; j++) {
                par[x][j] = par[par[x][j - 1]][j - 1];
            }
            dfs(i);
        }
    }
}

int calc(int x, int y) {
    if (x == 0 || y == 0) {
        return 0;
    }
    if (dis[x] < dis[y]) {
        swap(x, y);
    }
    int xx = x, yy = y;
    for (int b = B - 1; b >= 0; b--) {
        if (dis[par[x][b]] >= dis[y]) {
            x = par[x][b];
        }
    }
    if (x == y) {
        return dis[xx] - dis[yy];
    }
    for (int b = B - 1; b >= 0; b--) {
        if (par[x][b] != par[y][b]) {
            x = par[x][b]; y = par[y][b];
        }
    }
    return dis[xx] + dis[yy] - 2 * dis[par[x][0]];
}

void build(int v, int l, int r) {
    if (l == r) {
        d[0][v] = d[1][v] = p[l];
        return;
    }
    int m = (l + r) / 2, cc = 0;
    build(2 * v, l, m);
    build(2 * v + 1, m + 1, r);
    for (int i = 0; i < 2; i++) {
        for (int j = 0; j < 2; j++) {
            int c = calc(d[i][2 * v], d[j][2 * v + 1]);
            if (c > cc) {
                cc = c; d[0][v] = d[i][2 * v];
                d[1][v] = d[j][2 * v + 1];
            }
        }
    }
}

vector<int> calc_p(int v, int l, int r, int L, int R) {
    if (L > r || l > R) {
        return {0, 0};
    }
    if (L <= l && r <= R) {
        return {d[0][v], d[1][v]};
    }
    int m = (l + r) / 2, cc = -1;
    vector<int> p1 = calc_p(2 * v, l, m, L, R);
    vector<int> p2 = calc_p(2 * v + 1, m + 1, r, L, R);
    for (int i = 0; i < 2; i++) {
        for (int j = 0; j < 2; j++) {
            int c = calc(p1[i], p2[j]);
            if (c > cc) {
                cc = c; d[0][v] = p1[i];
                d[1][v] = p2[j];
            }
        }
    }
    return {d[0][v], d[1][v]};
}

void upd(int v, int l, int r, int x) {
    if (x < l || x > r) {
        return;
    }
    if (l == r) {
        d[0][v] = d[1][v] = p[l];
        return;
    }
    int m = (l + r) / 2, cc = 0;
    upd(2 * v, l, m, x);
    upd(2 * v + 1, m + 1, r, x);
    for (int i = 0; i < 2; i++) {
        for (int j = 0; j < 2; j++) {
            int c = calc(d[i][2 * v], d[j][2 * v + 1]);
            if (c > cc) {
                cc = c; d[0][v] = d[i][2 * v];
                d[1][v] = d[j][2 * v + 1];
            }
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);
    cin >> n;
    for (int i = 1; i <= n; i++) {
        cin >> p[i];
    }
    for (int i = 1; i < n; i++) {
        int a, b; cin >> a >> b;
        g[a].push_back(b);
        g[b].push_back(a);
    }
    dfs(1); build(1, 1, n);
    vector<int> ans;
    int q; cin >> q;
    while (q--) {
        int t; cin >> t;
        if (t == 1) {
            int a, b; cin >> a >> b;
            swap(p[a], p[b]);
            upd(1, 1, n, a);
            upd(1, 1, n, b);
        }
        else {
            int l, r, x;
            cin >> l >> r >> x;
            vector<int> z = calc_p(1, 1, n, l, r);
            int d1 = calc(x, z[0]);
            int d2 = calc(x, z[1]);
            ans.push_back(max(d1, d2));
        }
    }
    for (int i : ans) {
        cout << i << endl;
    }
}